// UD Blue team1
#include <vector>
#include <iostream>
#include <string>
#include <algorithm>
#include <complex>
#include <map>
#include <queue>

using namespace std;

vector<string> maze;
int k, w, h;

void readmaze() {
	string line;
	maze.clear();
	for(int i = 0; i < h; ++i) {
		getline(cin, line);
		line.resize(w);
		maze.push_back(line);
	}
}

typedef complex<int> pt;
vector<pt> newrobots;
vector<pt> findrobots() {
	vector<pt> robots(10);
	int found_robots = 0;
	for(int i = 0; i < h; ++i) {
		for(int j = 0; j < w; ++j) {
			if(isdigit(maze[i][j])) {
				int r = (int) maze[i][j] - '0';
				cerr << "maze[i][j] = " << maze[i][j] << " = " << r << endl;
				robots[r] = pt(i,j);
				maze[i][j] = ' ';
				++found_robots;
			}
		}
	}
	robots.resize(found_robots);
	k = found_robots;
	return robots;
}


bool robotcansee(pt r, pt y) {
	if(real(r-y) != 0 && imag(r-y) != 0) return false;
	if(real(r-y) == 0 && imag(r-y) == 0) return true;
	
	if(real(r) == real(y)) {
		// all maze spaces along imag line == ' ' ?
		int sm = min(imag(r), imag(y));
		int lg = max(imag(r), imag(y));
		for(int i = sm; i < lg; ++i)
			if(maze[real(r)][i] == 'X') return false;
		return true;
	} else {
		// all maze spaces along real line == ' ' ?
		int sm = min(real(r), real(y));
		int lg = max(real(r), real(y));
		for(int i = sm; i < lg; ++i)
			if(maze[i][imag(r)] == 'X') return false;
		return true;
	}
	cerr << "unexpected fallthrough in robotcansee!" << endl;
	return false;
}

pt findyou() {
	for(int i = 0; i < h; ++i) {
		for(int j = 0; j < w; ++j) {
			//cerr << "Y ==? " << maze[i][j] << endl;
			if('Y' == (maze[i][j])) {
				maze[i][j] = ' ';
				return pt(i,j);
			}
		}
	}
	cerr << "couldn't find you! error!" << endl;
	exit(1);
	return pt(-1,-1);
}

bool seen_with(vector<pt> robots, pt you) {
	for(int i = 0; i <robots.size(); ++i) {
		if(robotcansee(robots[i], you))
			return true;
	}
	return false;
}

vector<pt> nextmoves(pt you) {
	vector<pt> moves;
//	if(!seen_with(newrobots, you))
		moves.push_back(you); // not moving is always an option (...NOT!)

	if(real(you) - 1 >= 0 && maze[real(you) -1][imag(you)] != 'X')
//		if(!seen_with(newrobots, you + pt(-1,0)))
			moves.push_back(you + pt(-1, 0));

	if(real(you) + 1 < w && maze[real(you) + 1][imag(you)] != 'X')
		//if(!seen_with(newrobots, you + pt(1,0)))
			moves.push_back(you + pt(1, 0));

	if(imag(you) - 1 >= 0 && maze[real(you)][imag(you) -1] != 'X')
		//if(!seen_with(newrobots, you + pt(0,-1)))
			moves.push_back(you + pt(0, -1));

	if(real(you) + 1 < h && maze[real(you)][imag(you) + 1] != 'X')
		//if(!seen_with(newrobots, you + pt(0,1)))
			moves.push_back(you + pt(0, 1));

	return moves;
}

vector<string> robotmoves;
void getrobotmoves() {
	string moves;
	for(int i = 0; i < k; ++i) {
		getline(cin, moves);
		cerr << "moves are " << moves << endl;
		robotmoves.push_back(moves);
	}
}

struct state_t {
	pt you;
	vector<pt> robots;
	int steps;
};

vector<pt> findsteps(state_t state) {
	return nextmoves(state.you);
}


bool seen(state_t state) {
	for(int i = 0; i < state.robots.size(); ++i) {
		if(robotcansee(state.robots[i], state.you))
			return true;
	}
	return false;
}

string discard;

bool move_robots(state_t state) {
	int i = state.steps;
	if(i >= robotmoves.size()) return false;

	newrobots = vector<pt>(state.robots.size());
	for(int r = 0; r < state.robots.size(); ++r) {
		char dir = robotmoves[r][i];
		if(dir == 'E') newrobots[r] = state.robots[r] + pt(1,0);
		if(dir == 'N') newrobots[r] = state.robots[r] + pt(0,1);
		if(dir == 'S') newrobots[r] = state.robots[r] + pt(0,-1);
		if(dir == 'W') newrobots[r] = state.robots[r] + pt(-1,0);
	}
	return true;
}

int main() {
	while(true) {
		cin >> w >> h;
		getline(cin, discard);
		robotmoves.clear();
		cerr << "w and h are " << w << " and " << h << endl;
		if(w < 3 || h < 3)
			break;

		readmaze();
		vector<pt> robots = findrobots();
		pt you = findyou();

		getrobotmoves();

		queue<state_t> wl;

		state_t state;
		state.you = you;
		state.robots = robots;
		state.steps = 0;

		wl.push(state);
		cerr << "wl: " <<  wl.size() << endl;
		
		int maxsteps = -1;
		while(!wl.empty()) {
			state = wl.front(); wl.pop();
			cerr << "steps: " << state.steps << endl;
				maxsteps = max(state.steps, maxsteps);
			if(seen(state) && state.steps != 0) {
//				cerr << "seen after state " << state.steps << endl;
				maxsteps = max(state.steps, maxsteps);
				//break;
				continue;
			}
			bool cont = move_robots(state);
			// sets newrobots
			if(!cont) break; // there were no more robot moves to make!
			
			// otherwise, generate a list of moves we can make,
			// and add each move to the state q
			vector<pt> moves = findsteps(state);
			for(int i = 0; i < moves.size(); ++i) {
				state_t newstate;
				newstate.you = moves[i];
				newstate.robots = newrobots;
				newstate.steps = state.steps + 1;
				wl.push(newstate);
			}
		}
		
		cout << "You can hide for " << maxsteps << " turns." << endl;
	}
	return 0;
}
