// Team 1, UD Blue
#include <iostream>
#include <string>
#include <vector>
#include <cctype>
#include <cstdlib>

using namespace std;


vector<string> lcwords;
vector<string> sentences;
vector<string> lcsentences;

string lowercase(string in) {
	string out;
	for(int i = 0; i < in.size(); ++i)
		out.push_back(tolower(in[i]));
	return out;
}


bool get_wordlist() {
	lcwords.clear();
	sentences.clear();
	lcsentences.clear();

	string word, lcword;
	while(cin >> word) {
		if(word == "EndOfList")
			break;
		lcword = lowercase(word);	
		//cerr << "word is " << word << ", lcword is " << lcword << endl;
		lcwords.push_back(lcword);
	}
	getline(cin, word);
	if(word == "EndOfInput")
		return false;
	return true;
	cerr << "	gobbled word was " << word << endl;
	cerr << endl;
	fflush(stderr);
}

bool parse_message() {
	string line;
	string sentence;
	string lcs;
	int blanks = 0;
	do {
		getline(cin, line);
		/*
		cerr << "line is  " << line << endl;
		cerr << "sentence is : " << sentence  << endl;
		cerr << endl;
		*/

		if(line == "EndOfMsg") {
			cerr << "hit end of message!" << endl;
			// if we hit the end of a message, wrap up the last sentence
			// we were working on.
			sentences.push_back(sentence);
			break;
		}
		if(line == "EndOfInput")
			return false;
		
		// append missing newline
		line.push_back('\n');

		if(line.size() == 1) {
			// blank lines mark sentence boundaries
			sentences.push_back(sentence);
			sentences.push_back("\n");
			sentence = "";
			lcs = "";
//			if(++blanks > 5) exit(1);
		} else {
			if(sentence.size() > 0) {
				// we're continuing a sentence...
			//	sentence.push_back(' ');
			}

			for(int i = 0; i < line.size(); ++i) {
				char c = line[i];
				if(c == '.' || c == '?' || c == '!') {
					sentence.push_back(c);
					sentences.push_back(sentence);
					sentence = "";
				} else {
					sentence.push_back(c);
				}
			}
		}
	} while(true);

	return true;
}

string redact(string s) {
	string out = string(s);
	for(int i = 0; i < out.size(); ++i)
		if(out[i] != '\n')
			out[i] = '@';
	return out;
}

vector<string> tokenize(string in) {
	vector<string> tokens;
	string token;
	for(int i = 0; i < in.size(); ++i) {
		if(isalnum(in[i]))
			token.push_back(in[i]);
		else {
			if(!token.empty())
				tokens.push_back(token);
			token = "";
		}
	}
	return tokens;
}

void print_redaction() {
	for(int s = 0; s < sentences.size(); ++s) {
		bool doredact = false;
		vector<string> tokens = tokenize(lcsentences[s]);
		for(int t = 0; t < tokens.size(); ++t) {
			for(int w = 0; w < lcwords.size(); ++w) {
				if(lcwords[w] == tokens[t]) {
					doredact = true;
					break;
				}
			}
		}

		if(doredact) {
			cout << redact(sentences[s]);
		} else {
			cout << sentences[s];
		}
	}
	cout << "====" << endl;
}

int main() {
	bool cont = get_wordlist();
	if(!cont) return 0;
/*if(lcwords.size() == 0)

		return 0;
*/
	bool c2= parse_message();

	// convert sentences to lowercase
	for(int s = 0; s < sentences.size(); ++s) {
		string lcs = lowercase(sentences[s]);
		lcsentences.push_back(lcs);
	}
	cerr << "sentences: " << endl;
	for(int s = 0; s < sentences.size(); ++s) { cerr << sentences[s] << endl; }
	
	cerr << "lcsentences: " << endl;
	for(int s = 0; s < lcsentences.size(); ++s) { cerr << lcsentences[s] << endl; }
	
	print_redaction();

	if (cont)
	 return main();
	else return 0;
}
