#include <map>
#include <string>
#include <sstream>
#include <iostream>
#include <list>

using namespace std;

map<pair<string,string>, int> data;
list<pair<string, int> > chemicals;

list<pair<string, int> >::iterator chemicals_end;

int parse(map<string,int> bowl, list<pair<string,int> >::iterator ci) {
	map<string,int>::iterator b1, b2;
	int maxHeat = 0;
	bool production = false;

	for (b1 = bowl.begin(); b1 != bowl.end(); ++b1) {
		if (b1->second == 0) continue;
		for (b2 = bowl.begin(); b2 != bowl.end(); ++b2) {
			if (b2->second == 0) continue;

			int heat = data[make_pair(b1->first,b2->first)];
			if (heat == 0) continue;
			--heat;

			int consumed = min(b1->second, b2->second);
			map<string,int> newbowl = bowl;
			newbowl[b1->first] -= consumed;
			newbowl[b2->first] -= consumed;
			maxHeat = max(maxHeat, consumed*heat + parse(newbowl, ci));
			production = true;
		}
	}

	if (production)
		return maxHeat;
	if (ci == chemicals_end)
		return maxHeat;
	bowl[ci->first] += ci->second;
	return parse(bowl, ++ci);
}

int main() {
	string input;
	list<pair<string,int> > chemicals;
	
	data.clear();
	chemicals.clear();

	while(getline(cin, input)) {
		if (input == "0 0 0") break;
		if (input == "ENDOFINPUT") return 0;
		stringstream ss;
		string c1,c2;
		int h;
		ss << input;
		ss >> c1 >> c2 >> h;
		data[make_pair(c1,c2)] = h+1;
		data[make_pair(c2,c1)] = h+1;
	}


	while(getline(cin, input)) {
		if (input == "0 0") break;
		stringstream ss;
		string c1;
		int count;
		ss << input;
		ss >> c1 >> count;
		chemicals.push_back(make_pair(c1,count));
	}


	map<string,int> bowl;
	for (chemicals_end = chemicals.begin(); chemicals_end != chemicals.end(); ++chemicals_end) {
		bowl[chemicals_end->first] += chemicals_end->second;
	}
	
	chemicals_end = chemicals.end();
		
	int heat = parse(bowl, chemicals.end());
	cout << "The temperature in the jar will change by at most " << heat << " degrees." << endl;
	main();
}



		
