#include <iostream>
#include <string>
#include <sstream>
#include <map>

using namespace::std;

struct mobile
{
  int type;
  int id;
  double len;
  mobile * m1;
  mobile * m2;
  double weight;
};

stringstream ss;

mobile * createMobile (int type, int id, double len, mobile * m1, mobile * m2, double weight)
{
  mobile * m = new mobile();

  m->type = type;
  m->len = len;
  m->id = id;
  m->m1 = m1;
  m->m2 = m2;
  m->weight = weight;

  return m;
}

string getStr(string s)
{
  string tmp = "";
  int o = 0;
  int p = 0;
  int first = 1;

  cerr << "s" << s << endl;

  int i;
  for (i = 0; i < s.size(); i++)
    {
      cerr << "s[1]: " << s[i] << endl;

      if (first != 1 && o == p)
	{
	  break;
	}

      if (s[i] == '(') o++;
      else if (s[i] == ')') p++;


      first = 0;
    }

  return s.substr(1, i-1);
}

mobile * parse (string s)
{
  ss.clear();
  ss.str("");

  int len = s.size();

  string basic = s.substr(1, len-2);
  string tmp;

  ss << basic;
  ss >> tmp;

  cerr << "type: " << tmp << endl;

  if (tmp == "D")
    {
      double weight;
      ss >> weight;
      return createMobile (1, 0, 0, NULL, NULL, weight);
    }
  else
    {
      int id;
      double length;
      ss >> id;
      ss >> length;

      cerr << "id: " << id << " length: " << length << endl;

      tmp = basic.substr(basic.find_first_of("(")-1);
      cerr << "tmp: " << tmp << endl;

      string s1 = getStr(tmp);
      cerr << "s1: " << s1 << endl;
      string s2 = getStr(tmp.substr(s1.size()));
      cerr << "s2: " << s2 << endl;

      return createMobile (2, id, length, parse(s1), parse(s2), 0);
    }
  
}

map <int, double> offset;

double preformCalc (double w1, double w2, double length)
{
  return (w2 * length)/(w1 + w2);
}

double calc (mobile * n)
{
  if (n->type == 1)
    return n->weight;
  else
    {
      double w1 = calc (n->m1);
      double w2 = calc (n->m2);
      offset[n->id] = preformCalc (w1, w2, n->len);
      return w1 + w2;
    }
}

int main()
{
  string input, total;
  
  while (getline(cin, input))
    {
      if (input == "()") break;
      total += input;
    }

  mobile * head = parse (total);

  calc (head);

  map<int, double>::iterator i;
  for (i = offset.begin(); i != offset.end(); i++)
    {
      cout << i->first << ": " << i->second << endl;
    }
}
